<?php
// In real app, fetch from DB by slug
$name        = "Sea Breeze Resort Goa";
$address     = "Calangute Beach Road, Calangute, Goa, India";
$city        = "Calangute";
$country     = "India";
$lat         = 15.5432;
$lng         = 73.7553;
$affiliate   = "https://affiliate.example.com/goa-hotel?ref=tripgoeson";

$pageTitle = "$name – Hotel in $city, $country | TripGoesOn";
$pageDesc  = "Discover $name, a hotel in $city, $country. View details, map, FAQs and then check prices on our trusted partner site.";
include 'includes/header.php';
?>

<section class="py-4 bg-light border-bottom">
  <div class="container">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-1">
        <li class="breadcrumb-item"><a href="/">Home</a></li>
        <li class="breadcrumb-item"><a href="/india">India</a></li>
        <li class="breadcrumb-item"><a href="/india/goa/hotels">Goa Hotels</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?= htmlspecialchars($name) ?></li>
      </ol>
    </nav>
    <h1 class="h3 mb-0"><?= htmlspecialchars($name) ?></h1>
    <p class="small text-muted mb-0"><?= htmlspecialchars($address) ?></p>
  </div>
</section>

<section class="py-4">
  <div class="container">
    <div class="row g-4">
      <div class="col-lg-8">
        <!-- Image gallery -->
        <div class="mb-3">
          <img src="/assets/img/sample-hotel.jpg" class="img-fluid rounded shadow-sm"
               alt="<?= htmlspecialchars($name) ?> exterior view" loading="lazy">
        </div>

        <!-- Summary / AEO friendly -->
        <h2 class="h5">Overview</h2>
        <p>This property is a mid-range beachside hotel in Calangute, ideal for couples and families looking for easy access to Goa’s nightlife and beaches.</p>
        <ul>
          <li>Walking distance to Calangute Beach</li>
          <li>Rooms with balcony &amp; air conditioning</li>
          <li>On-site restaurant and swimming pool</li>
          <li>Free Wi-Fi in lobby areas</li>
        </ul>

        <!-- FAQ block for AEO -->
        <section class="mt-4">
          <h2 class="h5">Frequently Asked Questions</h2>

          <h3 class="h6 mt-3">What is the best time to visit this hotel?</h3>
          <p class="small">Peak season in Goa is November to February, with pleasant weather and many events. For lower prices and fewer crowds, consider October or March.</p>

          <h3 class="h6 mt-3">Is this property family friendly?</h3>
          <p class="small">Yes, the hotel welcomes families and offers a pool area and easy beach access. Always confirm current facilities on the partner website before booking.</p>

          <h3 class="h6 mt-3">How do I book this hotel?</h3>
          <p class="small">TripGoesOn.com is a travel directory only. Click on <strong>Check Prices</strong> below to visit our partner website and complete your booking securely there.</p>

          <h3 class="h6 mt-3">How can I reach the hotel from the airport?</h3>
          <p class="small">Dabolim Airport is about 40 km away. You can hire a prepaid taxi, app-based cab, or arrange a transfer via the booking partner.</p>
        </section>
      </div>

      <!-- Sidebar -->
      <div class="col-lg-4">
        <div class="card shadow-sm mb-3">
          <div class="card-body">
            <h2 class="h6 mb-2">Location</h2>
            <p class="small mb-2"><?= htmlspecialchars($address) ?></p>
            <div class="ratio ratio-4x3 mb-2">
              <!-- Replace with real map embed -->
              <iframe src="https://maps.google.com/maps?q=<?= $lat ?>,<?= $lng ?>&z=15&output=embed"
                      loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>

            <!-- Affiliate CTA -->
            <a href="<?= htmlspecialchars($affiliate) ?>"
               class="btn btn-primary w-100 mb-2" target="_blank" rel="nofollow sponsored">
              Check Prices on Partner Site
            </a>
            <p class="small text-muted mb-0">
              You’ll be redirected to a trusted booking partner. TripGoesOn.com does not handle payments or reservations.
            </p>
          </div>
        </div>

        <!-- Share -->
        <div class="card">
          <div class="card-body">
            <h2 class="h6 mb-2">Share this place</h2>
            <a class="small d-block mb-1" href="#">Share on WhatsApp</a>
            <a class="small d-block mb-1" href="#">Share on Facebook</a>
            <a class="small d-block" href="#">Copy link</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- JSON-LD Schema: Hotel + Breadcrumb -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Hotel",
  "name": "<?= addslashes($name) ?>",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Calangute Beach Road",
    "addressLocality": "Calangute",
    "addressRegion": "Goa",
    "addressCountry": "IN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": <?= $lat ?>,
    "longitude": <?= $lng ?>
  },
  "url": "https://www.tripgoeson.com<?= $_SERVER['REQUEST_URI'] ?>",
  "description": "Beachside hotel in Calangute, Goa listed on TripGoesOn.com travel directory.",
  "sameAs": ["<?= $affiliate ?>"]
}
</script>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "https://www.tripgoeson.com/"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "India",
      "item": "https://www.tripgoeson.com/india"
    },
    {
      "@type": "ListItem",
      "position": 3,
      "name": "Goa Hotels",
      "item": "https://www.tripgoeson.com/india/goa/hotels"
    },
    {
      "@type": "ListItem",
      "position": 4,
      "name": "<?= addslashes($name) ?>",
      "item": "https://www.tripgoeson.com<?= $_SERVER['REQUEST_URI'] ?>"
    }
  ]
}
</script>

<?php include 'includes/footer.php'; ?>
