<section class="city-page">
    <div class="container">

        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="<?php echo $siteurl.'/'.$countryRow['slug'].'/'; ?>">
                <?php echo htmlspecialchars($countryRow['name']); ?>
            </a>
            <span>›</span>
            <a href="<?php echo $siteurl.'/'.$countryRow['slug'].'/'.$stateRow['slug'].'/'; ?>">
                <?php echo htmlspecialchars($stateRow['name']); ?>
            </a>
            <span>›</span>
            <span><?php echo htmlspecialchars($cityRow['travelname']); ?></span>
        </nav>
       
        <h1><?php echo htmlspecialchars($cityRow['travelname']); ?></h1>
        <?php /* if (!empty($cityRow['travelicon'])) { ?>
            <img src="<?php echo $siteurl.'/images/travel/'.$cityRow['travelicon']; ?>"
                 class="img-responsive"
                 style="border-radius:1.5rem;margin:20px 0;"
                 alt="<?php echo htmlspecialchars($cityRow['travelname']); ?>">
        <?php } */ ?>
        
        <?php
// ================= CITY IMAGE SLIDER =================

// Main city image
$iurl   = $_SERVER['DOCUMENT_ROOT'].'/images/travel/'.$cityRow['travelicon'];
$webUrl = $siteurl.'/images/travel/'.$cityRow['travelicon'];

if (file_exists($iurl) && !empty($cityRow['travelicon'])) {
    $bigImg = $webUrl;
} else {
    $bigImg = $siteurl.'/travelimages/no-img.png';
}
?>

<div class="image-container city-slider">

    <!-- BIG IMAGE -->
    <div class="big-image">
        <img id="cityMainImage"
             src="<?php echo $bigImg; ?>"
             width="100%"
             height="300"
             style="border-radius:1rem;object-fit:cover;"
             alt="<?php echo htmlspecialchars($cityRow['travelname']); ?>">
    </div>

    <!-- THUMBNAILS -->
    <div class="small-image">

        <!-- MAIN IMAGE THUMB -->
        <img class="thumb active"
             src="<?php echo $bigImg; ?>"
             data-full="<?php echo $bigImg; ?>"
             alt="">

        <?php
        // CITY GALLERY IMAGES
        $cityID = (int)$cityRow['ID'];
        $queryGallery = dbquery("
            SELECT iconimage 
            FROM gallery 
            WHERE category = $cityID AND ctype = 2
        ");

        while ($g = dbfetch($queryGallery)) {
            $thumb = $siteurl.'/images/gallery/'.$cityID.'/'.$g['iconimage'];
        ?>
            <img class="thumb"
                 src="<?php echo $thumb; ?>"
                 data-full="<?php echo $thumb; ?>"
                 alt="">
        <?php } ?>

    </div>
</div>
<script>
document.addEventListener("DOMContentLoaded", function () {

    const mainImg = document.getElementById("cityMainImage");
    const thumbs  = document.querySelectorAll(".city-slider .thumb");

    thumbs.forEach(function (thumb) {
        thumb.addEventListener("click", function () {

            // Change big image
            mainImg.src = this.dataset.full;

            // Active state
            thumbs.forEach(t => t.classList.remove("active"));
            this.classList.add("active");
        });
    });

});
</script>

<style>
.city-slider .small-image {
    display: flex;
    gap: 10px;
    margin-top: 10px;
}
.city-slider .small-image img {
    width: 80px;
    height: 60px;
    object-fit: cover;
    cursor: pointer;
    border-radius: .5rem;
    opacity: .6;
    transition: .3s;
}
.city-slider .small-image img.active,
.city-slider .small-image img:hover {
    opacity: 1;
    border: 2px solid #0d6efd;
}
</style>

        
        
        

        <?php if (!empty($cityRow['description'])) { ?>
            <p class="lead"><?php echo $cityRow['description']; ?></p>
        <?php } ?>

     

        <hr>

        <!-- PLACES -->
        <h2>Places to Visit in <?php echo htmlspecialchars($cityRow['travelname']); ?></h2>

        <div class="row">
        <?php
        $placesQ = dbquery("SELECT ID, travelname, slug, shortdesc, travelicon 
            FROM travellisting WHERE region = $cityRow[region] AND status = 1 and ID!=$cityRow[ID] ORDER BY featured DESC, travelname ASC");

        if (dbnumrows($placesQ) == 0) {
            echo "<p>No places available.</p>";
        }

        while ($place = dbfetch($placesQ)) {

            $placeUrl = $siteurl.'/'
                . $countryRow['slug'].'/'
                . $stateRow['slug'].'/'
                
                . $place['slug'].'/';
        ?>
            <div class="col-md-4 col-sm-6">
                <div class="place-card">

                    <?php if ($place['travelicon']) { ?>
                        <img src="<?php echo $siteurl.'/images/travel/'.$place['travelicon']; ?>"
                             class="img-responsive"
                             alt="<?php echo htmlspecialchars($place['travelname']); ?>">
                    <?php } ?>

                    <h3>
                        <a href="<?php echo $placeUrl; ?>">
                            <?php echo htmlspecialchars($place['travelname']); ?>
                        </a>
                    </h3>

                    <p><?php echo short_text($place['shortdesc'], 120); ?></p>

                    <a href="<?php echo $placeUrl; ?>" class="btn btn-primary">
                        Explore Place
                    </a>
                </div>
            </div>
        <?php } ?>
        </div>

    </div>
</section>
