<section class="country-page">
    <div class="container">

        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <span><?php echo htmlspecialchars($countryRow['name']); ?></span>
        </nav>

        <!-- Heading -->
        <h1><?php echo htmlspecialchars($countryRow['name']); ?></h1>

        <!-- Description -->
        <?php if (!empty($countryRow['shortdes'])) { ?>
            <p class="lead"><?php echo nl2br($countryRow['shortdes']); ?></p>
        <?php } ?>

        <!-- Country Image -->
        <?php /* if (!empty($countryRow['img'])) { ?>
            <img src="<?php echo $siteurl.'/images/travelcategories/'.$countryRow['img']; ?>"
                 alt="<?php echo htmlspecialchars($countryRow['name']); ?>"
                 class="img-responsive"
                 style="border-radius:1.5rem;margin:20px 0;">
        <?php } */ ?>
        
        
        <?php
// ================= COUNTRY IMAGE SLIDER =================

// Main country image
$iurl   = $_SERVER['DOCUMENT_ROOT'].'/images/travelcategories/'.$countryRow['img'];
$webUrl = $siteurl.'/images/travelcategories/'.$countryRow['img'];

if (file_exists($iurl) && !empty($countryRow['img'])) {
    $bigImg = $webUrl;
} else {
    $bigImg = $siteurl.'/travelimages/no-img.png';
}
?>

<div class="image-container country-slider">

    <!-- BIG IMAGE -->
    <div class="big-image">
        <img id="countryMainImage"
             src="<?php echo $bigImg; ?>"
             width="100%"
             height="300"
             style="border-radius:1rem;object-fit:cover;"
             alt="<?php echo htmlspecialchars($countryRow['name']); ?>">
    </div>

    <!-- THUMBNAILS -->
    <div class="small-image">

        <!-- MAIN IMAGE THUMB -->
        <img class="thumb active"
             src="<?php echo $bigImg; ?>"
             data-full="<?php echo $bigImg; ?>"
             alt="">

        <?php
        // COUNTRY GALLERY IMAGES
        $countryID = (int)$countryRow['ID'];
        $queryGallery = dbquery("
            SELECT iconimage 
            FROM gallery 
            WHERE category = $countryID AND ctype = 1
        ");

        while ($g = dbfetch($queryGallery)) {
            $thumb = $siteurl.'/images/gallery/'.$countryID.'/'.$g['iconimage'];
        ?>
            <img class="thumb"
                 src="<?php echo $thumb; ?>"
                 data-full="<?php echo $thumb; ?>"
                 alt="">
        <?php } ?>

    </div>
</div>

        
        
        

        <hr>

        <!-- STATES -->
        <h2>States in <?php echo htmlspecialchars($countryRow['name']); ?></h2>

        <div class="row">
        <?php
        
        $statesQ = dbquery("SELECT name, slug, shortdes, img FROM travelcategories WHERE parent = $countryID and status=1 ORDER BY name ASC");

        if (dbnumrows($statesQ) == 0) {
            echo "<p>No states available.</p>";
        }

        while ($state = dbfetch($statesQ)) {

            $stateUrl = $siteurl.'/'
                . $countryRow['slug'].'/'
                . $state['slug'].'/';
        ?>
            <div class="col-md-4 col-sm-6">
                <div class="state-card">

                    <?php if (!empty($state['img'])) { ?>
                        <img src="<?php echo $siteurl.'/images/travelcategories/'.$state['img']; ?>"
                             class="img-responsive"
                             alt="<?php echo htmlspecialchars($state['name']); ?>">
                    <?php } ?>

                    <h3>
                        <a href="<?php echo $stateUrl; ?>">
                            <?php echo htmlspecialchars($state['name']); ?>
                        </a>
                    </h3>

                    <p><?php echo short_text($state['shortdes'], 120); ?></p>

                    <a href="<?php echo $stateUrl; ?>" class="btn btn-primary">
                        Explore State
                    </a>
                </div>
            </div>
        <?php } ?>
        </div>

    </div>
</section>

<script>
document.addEventListener("DOMContentLoaded", function () {

    const mainImg = document.getElementById("countryMainImage");
    const thumbs  = document.querySelectorAll(".country-slider .thumb");

    thumbs.forEach(function (thumb) {
        thumb.addEventListener("click", function () {

            // Change big image
            mainImg.src = this.dataset.full;

            // Active thumbnail
            thumbs.forEach(t => t.classList.remove("active"));
            this.classList.add("active");
        });
    });

});
</script>

<style>
.country-slider .small-image {
    display: flex;
    gap: 10px;
    margin-top: 10px;
}
.country-slider .small-image img {
    width: 80px;
    height: 60px;
    object-fit: cover;
    cursor: pointer;
    border-radius: .5rem;
    opacity: .6;
    transition: .3s;
}
.country-slider .small-image img.active,
.country-slider .small-image img:hover {
    opacity: 1;
    border: 2px solid #0d6efd;
}
</style>
