<section class="state-page">
    <div class="container">

        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="<?php echo $siteurl.'/'.$countryRow['slug'].'/'; ?>">
                <?php echo htmlspecialchars($countryRow['name']); ?>
            </a>
            <span>›</span>
            <span><?php echo htmlspecialchars($stateRow['name']); ?></span>
        </nav>
        
        <!-- State Image -->
        <?php /* if (!empty($stateRow['img'])) { ?>
            <img src="<?php echo $siteurl.'/images/travelcategories/'.$stateRow['img']; ?>"
                 alt="<?php echo htmlspecialchars($stateRow['name']); ?>"
                 class="img-responsive"
                 style="border-radius:1.5rem;margin:20px 0;">
        <?php } */ ?>
        
        <?php
// ================= STATE IMAGE SLIDER =================

// Main state image
$iurl   = $_SERVER['DOCUMENT_ROOT'].'/images/travelcategories/'.$stateRow['img'];
$webUrl = $siteurl.'/images/travelcategories/'.$stateRow['img'];

if (file_exists($iurl) && !empty($stateRow['img'])) {
    $bigImg = $webUrl;
} else {
    $bigImg = $siteurl.'/travelimages/no-img.png';
}
?>

<div class="image-container state-slider">

    <!-- BIG IMAGE -->
    <div class="big-image">
        <img id="stateMainImage"
             src="<?php echo $bigImg; ?>"
             width="100%"
             height="300"
             style="border-radius:1rem;object-fit:cover;">
    </div>

    <!-- THUMBNAILS -->
    <div class="small-image">
        <img class="thumb active"
             src="<?php echo $bigImg; ?>"
             data-full="<?php echo $bigImg; ?>"
             alt="">

        <?php
        $stateID = (int)$stateRow['ID'];
        $queryGallery = dbquery("
            SELECT iconimage 
            FROM gallery 
            WHERE category = $stateID AND ctype = 1
        ");

        while ($g = dbfetch($queryGallery)) {
            $thumb = $siteurl.'/images/gallery/'.$stateID.'/'.$g['iconimage'];
        ?>
            <img class="thumb"
                 src="<?php echo $thumb; ?>"
                 data-full="<?php echo $thumb; ?>"
                 alt="">
        <?php } ?>
    </div>
</div>

  <script>
document.addEventListener("DOMContentLoaded", function () {

    const mainImg = document.getElementById("stateMainImage");
    const thumbs  = document.querySelectorAll(".state-slider .thumb");

    thumbs.forEach(function (thumb) {
        thumb.addEventListener("click", function () {

            // Change big image
            mainImg.src = this.dataset.full;

            // Active class toggle
            thumbs.forEach(t => t.classList.remove("active"));
            this.classList.add("active");
        });
    });

});
</script>
<style>
.state-slider .small-image {
    display: flex;
    gap: 10px;
    margin-top: 10px;
}
.state-slider .small-image img {
    width: 80px;
    height: 60px;
    object-fit: cover;
    cursor: pointer;
    border-radius: .5rem;
    opacity: .6;
    transition: .3s;
}
.state-slider .small-image img.active,
.state-slider .small-image img:hover {
    opacity: 1;
    border: 2px solid #0d6efd;
}
</style>
      
        
        
        

        <hr>

        <!-- Heading -->
        <h1><?php echo $stateRow['name']; ?></h1>

        <!-- Description -->
        <?php if (!empty($stateRow['shortdes'])) { ?>
            <p class="lead"><?php echo nl2br($stateRow['shortdes']); ?></p>
        <?php } ?>

        

        <!-- Cities -->
        <h2>Cities in <?php echo htmlspecialchars($stateRow['name']); ?></h2>

        <div class="row">
        <?php
        
        
        
        $citiesQ = dbquery("SELECT travelname, slug, shortdesc, travelicon FROM  travellisting  WHERE catid = $stateID ORDER BY travelname ASC");

        if (dbnumrows($citiesQ) == 0) {
            echo "<p>No cities available.</p>";
        }

        while ($city = dbfetch($citiesQ)) {

            $cityUrl = $siteurl.'/'
                . $countryRow['slug'].'/'
                . $stateRow['slug'].'/'
                . $city['slug'].'/';
        ?>
            <div class="col-md-4 col-sm-6">
                <div class="city-card">

                    <?php if ($city['travelicon']) { ?>
                        <img src="<?php echo $siteurl.'/images/travel/'.$city['travelicon']; ?>"
                             class="img-responsive"
                             alt="<?php echo htmlspecialchars($city['travelname']); ?>">
                    <?php } ?>

                    <h3>
                        <a href="<?php echo $cityUrl; ?>">
                            <?php echo htmlspecialchars($city['travelname']); ?>
                        </a>
                    </h3>

                    <p><?php echo short_text($city['shortdesc'], 120); ?></p>

                    <a href="<?php echo $cityUrl; ?>" class="btn btn-primary">
                        Explore City
                    </a>
                </div>
            </div>
        <?php } ?>
        </div>

    </div>
</section>
