<?php

if (!isset($pageTitle)) { $pageTitle = "TripGoesOn – Travel Directory & Guides"; }

if (!isset($pageDesc))  { $pageDesc  = "Discover destinations, hotels, attractions and local travel services worldwide with TripGoesOn.com – your global travel directory."; }

?>

<!doctype html>

<html lang="en">

<head>

  <meta charset="utf-8">

  <title><?= htmlspecialchars($pageTitle) ?></title>

  <meta name="description" content="<?= htmlspecialchars($pageDesc) ?>">

  <meta name="viewport" content="width=device-width, initial-scale=1">



  <!-- Open Graph (good for SEO + AEO previews) -->

  <meta property="og:title" content="<?= htmlspecialchars($pageTitle) ?>">

  <meta property="og:description" content="<?= htmlspecialchars($pageDesc) ?>">

  <meta property="og:site_name" content="TripGoesOn">

  <meta property="og:type" content="website">

  <meta property="og:url" content="https://www.tripgoeson.com<?= $_SERVER['REQUEST_URI'] ?>">



  <!-- Bootstrap (optional) -->

  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

  <link rel="stylesheet" href="/assets/css/style.css">

</head>

<body>

<header class="border-bottom bg-white">

  <nav class="navbar navbar-expand-lg container py-2">

    <a class="navbar-brand fw-bold text-primary" href="/">TripGoesOn<span class="text-danger">.com</span></a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMain">

      <span class="navbar-toggler-icon"></span>

    </button>

    <div class="collapse navbar-collapse" id="navMain">

      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">

        <li class="nav-item"><a class="nav-link" href="/listings.php?type=hotels">Hotels</a></li>

        <li class="nav-item"><a class="nav-link" href="/listings.php?type=tours">Tours</a></li>

        <li class="nav-item"><a class="nav-link" href="/listings.php?type=attractions">Attractions</a></li>

        <li class="nav-item"><a class="nav-link" href="/blog.php">Travel Tips</a></li>

      </ul>

    </div>

  </nav>

</header>

<main>

