<?php

$pageTitle = "TripGoesOn – Discover Destinations, Hotels & Attractions Worldwide";

$pageDesc  = "TripGoesOn.com is a global travel directory helping you discover places to stay, things to do and local experiences – with future affiliate deals on hotels, tours and travel services.";

include 'includes/header.php';

?>



<section class="bg-light py-5">

  <div class="container">

    <div class="row align-items-center g-4">

      <div class="col-lg-7">

        <h1 class="fw-bold mb-3">Search the World with TripGoesOn</h1>

        <p class="lead">Find destinations, hotels, attractions and local travel services – compare options, read details and then book directly on partner sites.</p>



        <!-- Main directory search (AEO + SearchAction ready) -->

        <form class="row g-2" action="/listings.php" method="get">

          <div class="col-12 col-md-8">

            <input type="text" name="q" class="form-control form-control-lg"

                   placeholder="Search destination, hotel, attraction, city…">

          </div>

          <div class="col-12 col-md-4 d-grid">

            <button class="btn btn-primary btn-lg">Search Directory</button>

          </div>

        </form>



        <p class="small mt-2 text-muted">Examples: “Hotels in Goa”, “Attractions in Dubai”, “Family-friendly resorts in Thailand”.</p>

      </div>



      <div class="col-lg-5">

        <!-- Hero image -->

        <img src="/assets/img/hero-world-travel.jpg"

             alt="Travelers exploring destinations around the world"

             class="img-fluid rounded shadow-sm" loading="lazy">

      </div>

    </div>

  </div>

</section>



<!-- GEO-based suggestions (static demo – later hook to IP/Geo) -->

<section class="py-5">

  <div class="container">

    <h2 class="h4 mb-3">Places Near You</h2>

    <p class="small text-muted">Location-aware suggestions can be shown here based on city / country.</p>

    <div class="row g-3">

      <?php

      // Example tiles – replace with dynamic data

      $nearby = [

        ['name' => 'Delhi, India', 'slug' => '/india/delhi/attractions'],

        ['name' => 'Dubai, UAE', 'slug' => '/uae/dubai/attractions'],

        ['name' => 'Bangkok, Thailand', 'slug' => '/thailand/bangkok/hotels'],

      ];

      foreach ($nearby as $place): ?>

        <div class="col-12 col-sm-4">

          <a href="<?= $place['slug'] ?>" class="card h-100 text-decoration-none text-dark">

            <div class="card-body">

              <h3 class="h6 mb-1"><?= htmlspecialchars($place['name']) ?></h3>

              <p class="small text-muted mb-0">Explore hotels, attractions & local experiences.</p>

            </div>

          </a>

        </div>

      <?php endforeach; ?>

    </div>

  </div>

</section>



<!-- Popular countries -->

<section class="py-5 bg-light">

  <div class="container">

    <h2 class="h4 mb-4">Popular Destinations</h2>

    <div class="row g-3">

      <?php

      $countries = [

        ['name' => 'India', 'slug' => '/india', 'img' => 'india.jpg'],

        ['name' => 'UAE', 'slug' => '/uae', 'img' => 'uae.jpg'],

        ['name' => 'Thailand', 'slug' => '/thailand', 'img' => 'thailand.jpg'],

        ['name' => 'UK', 'slug' => '/uk', 'img' => 'uk.jpg'],

        ['name' => 'USA', 'slug' => '/usa', 'img' => 'usa.jpg'],

        ['name' => 'Europe', 'slug' => '/europe', 'img' => 'europe.jpg'],

      ];

      foreach ($countries as $c): ?>

        <div class="col-6 col-md-4 col-lg-2">

          <a href="<?= $c['slug'] ?>" class="text-decoration-none text-dark">

            <div class="card border-0 shadow-sm h-100">

              <img src="/assets/img/<?= $c['img'] ?>" class="card-img-top"

                   alt="Travel in <?= htmlspecialchars($c['name']) ?>" loading="lazy">

              <div class="card-body text-center">

                <h3 class="h6 mb-0"><?= htmlspecialchars($c['name']) ?></h3>

              </div>

            </div>

          </a>

        </div>

      <?php endforeach; ?>

    </div>

  </div>

</section>



<!-- Categories -->

<section class="py-5">

  <div class="container">

    <h2 class="h4 mb-4">Browse by Category</h2>

    <div class="row g-3">

      <?php

      $cats = [

        ['name' => 'Hotels',       'slug' => '/listings.php?type=hotels'],

        ['name' => 'Tours',        'slug' => '/listings.php?type=tours'],

        ['name' => 'Attractions',  'slug' => '/listings.php?type=attractions'],

        ['name' => 'Restaurants',  'slug' => '/listings.php?type=restaurants'],

        ['name' => 'Travel Tips',  'slug' => '/blog.php'],

      ];

      foreach ($cats as $cat): ?>

        <div class="col-6 col-md-3 col-lg-2">

          <a href="<?= $cat['slug'] ?>" class="btn btn-outline-primary w-100 mb-2">

            <?= htmlspecialchars($cat['name']) ?>

          </a>

        </div>

      <?php endforeach; ?>

    </div>

  </div>

</section>



<!-- Featured guides / AEO-style content -->

<section class="py-5 bg-light">

  <div class="container">

    <h2 class="h4 mb-3">Featured City Guides & Travel Insights</h2>

    <div class="row g-3">

      <div class="col-md-4">

        <article class="card h-100">

          <div class="card-body">

            <h3 class="h6">Best Time to Visit the Maldives</h3>

            <p class="small text-muted">

              Discover ideal seasons, weather tips and budget-friendly months for Maldives travel.

            </p>

            <a href="/blog/maldives-best-time.php" class="small">Read guide →</a>

          </div>

        </article>

      </div>

      <div class="col-md-4">

        <article class="card h-100">

          <div class="card-body">

            <h3 class="h6">Family-Friendly Attractions in Dubai</h3>

            <p class="small text-muted">Top theme parks, malls and cultural spots perfect for families.</p>

            <a href="/blog/dubai-family-attractions.php" class="small">Read guide →</a>

          </div>

        </article>

      </div>

      <div class="col-md-4">

        <article class="card h-100">

          <div class="card-body">

            <h3 class="h6">Budget Travel Hacks for Thailand</h3>

            <p class="small text-muted">Save on stay, food and transport while enjoying Thailand.</p>

            <a href="/blog/thailand-budget-travel.php" class="small">Read guide →</a>

          </div>

        </article>

      </div>

    </div>

  </div>

</section>



<?php include 'includes/footer.php'; ?>

