<?php

$type = $_GET['type'] ?? 'hotels';

$q    = $_GET['q']    ?? '';



$prettyType = ucfirst($type);

$pageTitle  = "$prettyType Directory – TripGoesOn";

$pageDesc   = "Browse $prettyType on TripGoesOn.com. Find detailed info, maps and affiliate links to book directly with providers.";

include 'includes/header.php';

?>



<section class="py-4 bg-light border-bottom">

  <div class="container">

    <!-- Breadcrumb -->

    <nav aria-label="breadcrumb">

      <ol class="breadcrumb mb-1">

        <li class="breadcrumb-item"><a href="/">Home</a></li>

        <li class="breadcrumb-item active" aria-current="page"><?= htmlspecialchars($prettyType) ?></li>

      </ol>

    </nav>

    <h1 class="h3 mb-0">

      <?= htmlspecialchars($prettyType) ?> Directory

      <?php if ($q): ?> – “<?= htmlspecialchars($q) ?>”<?php endif; ?>

    </h1>

    <p class="small text-muted mb-0">Filter by location, rating, budget and more.</p>

  </div>

</section>



<section class="py-4">

  <div class="container">

    <div class="row">

      <!-- Filters -->

      <aside class="col-md-3 mb-4">

        <form class="card p-3 bg-light">

          <h2 class="h6 mb-3">Filter Results</h2>

          <div class="mb-2">

            <label class="form-label small">Location</label>

            <input type="text" class="form-control form-control-sm" name="location"

                   placeholder="City, country">

          </div>

          <div class="mb-2">

            <label class="form-label small">Rating</label>

            <select class="form-select form-select-sm" name="rating">

              <option value="">Any</option>

              <option>4+ stars</option>

              <option>3+ stars</option>

            </select>

          </div>

          <div class="mb-2">

            <label class="form-label small">Budget</label>

            <select class="form-select form-select-sm" name="budget">

              <option value="">Any</option>

              <option>Budget</option>

              <option>Mid-range</option>

              <option>Luxury</option>

            </select>

          </div>

          <div class="mb-3">

            <label class="form-label small">Sort By</label>

            <select class="form-select form-select-sm" name="sort">

              <option>Popularity</option>

              <option>Rating</option>

              <option>Price (low to high)</option>

            </select>

          </div>

          <button class="btn btn-primary btn-sm w-100">Apply Filters</button>

        </form>

      </aside>



      <!-- Listings -->

      <div class="col-md-9">

        <div class="d-flex justify-content-between align-items-center mb-3">

          <p class="small mb-0">Showing sample listings (replace with DB results).</p>

          <button class="btn btn-outline-secondary btn-sm">Map View</button>

        </div>



        <?php

        // Example array; replace with DB.

        $listings = [

          [

            'name' => 'Sea Breeze Resort Goa',

            'location' => 'Calangute, Goa, India',

            'type' => 'Hotel',

            'url'  => '/listing-detail.php?slug=sea-breeze-goa',

            'affiliate' => 'https://affiliate.example.com/goa-hotel?ref=tripgoeson',

          ],

          [

            'name' => 'Desert Safari Dubai Experience',

            'location' => 'Dubai, UAE',

            'type' => 'Tour',

            'url'  => '/listing-detail.php?slug=desert-safari-dubai',

            'affiliate' => 'https://affiliate.example.com/dubai-safari?ref=tripgoeson',

          ],

        ];

        foreach ($listings as $item): ?>

          <article class="card mb-3">

            <div class="row g-0">

              <div class="col-md-4">

                <a href="<?= $item['url'] ?>">

                  <img src="/assets/img/sample-listing.jpg" class="img-fluid rounded-start h-100 object-fit-cover"

                       alt="<?= htmlspecialchars($item['name']) ?>" loading="lazy">

                </a>

              </div>

              <div class="col-md-8">

                <div class="card-body">

                  <h2 class="h6 mb-1">

                    <a href="<?= $item['url'] ?>" class="text-decoration-none">

                      <?= htmlspecialchars($item['name']) ?>

                    </a>

                  </h2>

                  <p class="small text-muted mb-1"><?= htmlspecialchars($item['location']) ?> · <?= $item['type'] ?></p>

                  <p class="small mb-2">Short description of the property, tour or attraction to help users decide.</p>



                  <!-- Affiliate CTA – outbound only -->

                  <a href="<?= htmlspecialchars($item['affiliate']) ?>"

                     class="btn btn-sm btn-primary me-2" rel="nofollow sponsored" target="_blank">

                    Check Prices

                  </a>

                  <a href="<?= $item['url'] ?>" class="btn btn-sm btn-outline-secondary">View Details</a>

                </div>

              </div>

            </div>

          </article>

        <?php endforeach; ?>

      </div>

    </div>

  </div>

</section>



<?php include 'includes/footer.php'; ?>

