<?php include 'header.php';
?>
    <style>
        
        .tgo-about-page {
           
            line-height: 1.7;
            color: #2c3e50;
           
            min-height: 100vh;
            padding: 40px 20px;
        }

        .tgo-about-container {
            max-width: 1000px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
        }

        .tgo-about-hero {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 60px 40px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .tgo-about-hero::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 50px 50px;
            animation: tgo-movePattern 20s linear infinite;
        }

        @keyframes tgo-movePattern {
            0% { transform: translate(0, 0); }
            100% { transform: translate(50px, 50px); }
        }

        .tgo-about-page h1 {
            font-size: 3em;
            margin-bottom: 20px;
            position: relative;
            z-index: 1;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        }

        .tgo-about-content {
            padding: 50px 40px;
        }

        .tgo-about-page nav {
            background: #f8f9fa;
            padding: 25px;
            border-radius: 15px;
            margin-bottom: 40px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }

        .tgo-about-page nav ul {
            list-style: none;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 12px;
        }

        .tgo-about-page nav a {
            display: block;
            padding: 12px 20px;
            background: white;
            color: #667eea;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }

        .tgo-about-page nav a:hover {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
        }

        .tgo-about-page h2 {
            font-size: 2em;
            color: #667eea;
            margin: 40px 0 20px 0;
            padding-bottom: 15px;
            border-bottom: 3px solid #667eea;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .tgo-about-page h3 {
            font-size: 1.5em;
            color: #764ba2;
            margin: 25px 0 15px 0;
        }

        .tgo-about-page p {
            margin-bottom: 20px;
            font-size: 1.05em;
        }

        .tgo-about-page strong {
            color: #667eea;
            font-weight: 600;
        }

        .tgo-about-page ul {
            margin: 20px 0 20px 30px;
        }

        .tgo-about-page ul li {
            margin-bottom: 12px;
            position: relative;
            padding-left: 10px;
        }

        .tgo-about-page ul li::marker {
            color: #667eea;
            font-weight: bold;
        }

        .tgo-about-page hr {
            border: none;
            height: 2px;
            background: linear-gradient(to right, transparent, #667eea, transparent);
            margin: 30px 0;
        }

        .tgo-about-section {
            background: #f8f9fa;
            padding: 30px;
            border-radius: 15px;
            margin: 30px 0;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
            transition: transform 0.3s ease;
        }

        .tgo-about-section:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }

        .tgo-about-highlight {
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
            border-left: 5px solid #667eea;
            padding: 25px;
            border-radius: 10px;
            margin: 25px 0;
        }

        @media (max-width: 768px) {
            .tgo-about-page {
                padding: 20px 10px;
            }

            .tgo-about-hero {
                padding: 40px 20px;
            }

            .tgo-about-page h1 {
                font-size: 2em;
            }

            .tgo-about-content {
                padding: 30px 20px;
            }

            .tgo-about-page h2 {
                font-size: 1.5em;
            }

            .tgo-about-page nav ul {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="tgo-about-page">
        <div class="tgo-about-container">
            <div class="tgo-about-hero">
                <h1 class='text-center' id="about-tripgoeson">About Us</h1>
            </div>

            <div class="tgo-about-content">
                <!--<nav aria-label="About Us Quick Links">-->
                <!--    <ul>-->
                <!--        <li><a href="#discover">Discover the World</a></li>-->
                <!--        <li><a href="#who-we-are">Who We Are</a></li>-->
                <!--        <li><a href="#what-we-do">What We Do</a></li>-->
                <!--        <li><a href="#why-choose">Why Choose Us</a></li>-->
                <!--        <li><a href="#mission-vision">Mission & Vision</a></li>-->
                <!--        <li><a href="#global-audience">Global Audience</a></li>-->
                <!--        <li><a href="#transparency">Transparency & Disclosure</a></li>-->
                <!--        <li><a href="#quality-accuracy">Quality & Accuracy</a></li>-->
                <!--        <li><a href="#start-exploring">Start Exploring</a></li>-->
                <!--    </ul>-->
                <!--</nav>-->

                <hr>

                <div class="tgo-about-section">
                    <h2 id="discover">🌍 Discover the World, One Trip at a Time</h2>
                    <p>
                        At <strong>TripGoesOn.com</strong>, we believe that every journey begins with inspiration and reliable information. Our goal is to help travelers explore the world with confidence by providing easy-to-navigate travel guides, destination insights, and curated travel resources — all in one place.
                    </p>
                    <p>
                        Whether you're planning your first international adventure, a weekend getaway, or a bucket-list trip, TripGoesOn.com is designed to make travel discovery simple, enjoyable, and trustworthy.
                    </p>
                </div>

                <div class="tgo-about-section">
                    <h2 id="who-we-are">✈️ Who We Are</h2>
                    <p>
                        <strong>TripGoesOn.com</strong> is a global travel directory built by travel researchers, explorers, and digital content specialists who share a deep passion for discovering new places and cultures.
                    </p>
                    <p>
                        Our team continuously researches destinations, cities, attractions, and travel experiences across the globe to ensure our content remains relevant, helpful, and up-to-date. We focus on accuracy, clarity, and user intent — so travelers can make informed decisions with ease.
                    </p>
                </div>

                <div class="tgo-about-section">
                    <h2 id="what-we-do">🧭 What We Do</h2>
                    <p>TripGoesOn.com helps travelers by offering:</p>
                    <ul>
                        <li>Comprehensive destination and city guides</li>
                        <li>Curated lists of attractions and things to do</li>
                        <li>Suggested itineraries and trip ideas</li>
                        <li>Informative travel tips for planning and exploration</li>
                    </ul>
                    <p>
                        Our platform acts as a travel discovery hub, connecting travelers with ideas, insights, and resources to plan unforgettable journeys around the world.
                    </p>
                </div>

                <div class="tgo-about-section">
                    <h2 id="why-choose">⭐ Why Choose TripGoesOn.com</h2>
                    <p>We are committed to quality and transparency. Here's what sets us apart:</p>
                    <ul>
                        <li><strong>Research-Driven Content</strong> – Carefully reviewed for accuracy and usefulness</li>
                        <li><strong>Global Coverage</strong> – Major cities and hidden gems worldwide</li>
                        <li><strong>User-Focused Experience</strong> – Clean layout and intuitive navigation</li>
                        <li><strong>Regular Updates</strong> – Reflecting current travel trends</li>
                        <li><strong>Unbiased Travel Insights</strong> – Traveler-first recommendations</li>
                    </ul>
                </div>

                <div class="tgo-about-highlight">
                    <h2 id="mission-vision">🎯 Our Vision & Mission</h2>
                    <h3>Our Mission</h3>
                    <p>
                        To simplify travel planning by providing reliable, well-structured, and inspiring travel information for travelers worldwide.
                    </p>
                    <h3>Our Vision</h3>
                    <p>
                        To become a trusted global travel directory that travelers return to at every stage of their journey — from inspiration to exploration.
                    </p>
                </div>

                <div class="tgo-about-section">
                    <h2 id="global-audience">🌎 Built for Travelers Worldwide</h2>
                    <p>
                        TripGoesOn.com is created for a global audience. We welcome travelers from all countries, cultures, and backgrounds.
                    </p>
                    <p>
                        No matter where you're from or where you're going — <strong>your trip goes on with us</strong>.
                    </p>
                </div>

                <div class="tgo-about-section">
                    <h2 id="transparency">🔍 Transparency, Trust & Affiliate Disclosure</h2>
                    <p>
                        Some pages may include affiliate links or advertisements. We may earn a small commission at no extra cost to you.
                    </p>
                    <ul>
                        <li>Content is independently researched</li>
                        <li>Affiliate relationships do not influence recommendations</li>
                        <li>User trust always comes first</li>
                    </ul>
                </div>

                <div class="tgo-about-section">
                    <h2 id="quality-accuracy">🤝 Our Commitment to Quality & Accuracy</h2>
                    <ul>
                        <li>First-hand research and verified sources</li>
                        <li>Honest and helpful travel insights</li>
                        <li>Clear, up-to-date information</li>
                    </ul>
                    <p>
                        We continuously review and improve our content to maintain high standards of accuracy and usefulness.
                    </p>
                </div>

                <div class="tgo-about-highlight">
                    <h2 id="start-exploring">🚀 Start Exploring with TripGoesOn.com</h2>
                    <p>
                        Travel is more than reaching a destination — it's about discovery, experience, and memories that last a lifetime.
                    </p>
                    <p>
                        Let <strong>TripGoesOn.com</strong> be your trusted companion in exploring the world.
                    </p>
                </div>
            </div>
        </div>
    </div>

<?php include 'footer.php';?>