<?php

function validatet($ad) {

  $ad=trim($ad);

  $ad=str_ireplace("'","",$ad);

  $ad=str_ireplace("\"","",$ad);

  $ad=str_ireplace("\\","",$ad);

  $ad=str_ireplace("<script","",$ad);

  $ad=str_ireplace("</script","",$ad);

  $ad=str_ireplace("<iframe","",$ad);

  $ad=str_ireplace("</iframe","",$ad);

  $ad=str_ireplace("&lt;script","",$ad);

  $ad=str_ireplace("&lt;IFRAME","",$ad);

  $ad=str_ireplace("&lt;/script","",$ad);

  $ad=str_ireplace("&lt;/IFRAME","",$ad);



  return $ad;

}

function send_mailer($to,$subject,$message,$format,$mtype,$from) {

	include("config.php");



	

	$subject=stripslashes($subject);

	$message=stripslashes($message);

	

	if($mtype==1) {	

		$from=$webmasteremail;

    	$header = "From: $sitename<$from>\n";

if($format==1)	$header .="Content-type: text/plain; charset=utf-8\n";

else	$header .="Content-type: text/html; charset=utf-8\n";

		$header .= "Reply-To: <$from>\n";

		$header .= "X-Sender: <$from>\n";

		$header .= "X-Mailer: PHP".phpversion()."\n";

		$header .= "X-Priority: 3\n";

		$header .= "Return-Path: <$from>\n";

		mail($to,$subject,$message,$header);

	}elseif($mtype==2) {

		require_once('swift/lib/swift_required.php');

		$sslt="";

		if($sslreq==1) $sslt="ssl";

		$transport = Swift_SmtpTransport::newInstance($mailserver, $mailport, $sslt)

		  ->setUsername($mailuser)

		  ->setPassword($mailpass);

		$mailer = Swift_Mailer::newInstance($transport);

		if($format==1)	$ftype="text/plain";

		else			$ftype="text/html";

		$message = Swift_Message::newInstance($subject)

		  ->setFrom(array($from => $sitename))

		  ->setReplyTo($from)

		  ->setReturnPath($from)

		  ->setTo(array($to))

		  ->setBody($message,$ftype);

		try  { 	$result = $mailer->send($message); } catch (Exception $e) {   return $e; }

	}

}



function authenticateemail($key,$email) {

	$email = urlencode($email);



	$url = "https://api.e-mailcourt.com/?key=$key&email=$email";

	$ch = curl_init($url);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	$response = curl_exec($ch);

	curl_close($ch);

	

	$json = json_decode($response, true);



	if (is_bool($json['Result']) === true) return TRUE;

	elseif($json['Result']=="failed") return $json['err'];

	else return "Unknown";

}





function showratestar($rating)

{

	$rating = round($rating,0);

	switch ($rating)

	{

	   case 0:

		 $str = '<img src="images/blankstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png">';

		 break;

	   case 1:

		 $str = '<img src="images/halfstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png">';

		 break;	

	   case 2:

		 $str = '<img src="images/star.png"><img src="images/blankstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png">';

		 break;

	   case 3:

		 $str = '<img src="images/star.png"><img src="images/halfstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png">';

		 break;

	   case 4:

		 $str = '<img src="images/star.png"><img src="images/star.png"><img src="images/blankstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png">';

		 break;

	   case 5:

		 $str = '<img src="images/star.png"><img src="images/star.png"><img src="images/halfstar.png"><img src="images/blankstar.png"><img src="images/blankstar.png">';

		 break;

	   case 6:

		 $str = '<img src="images/star.png"><img src="images/star.png"><img src="images/star.png"><img src="images/blankstar.png"><img src="images/blankstar.png">';

		 break;

	   case 7:

		 $str = '<img src="images/star.png"><img src="images/star.png"><img src="images/star.png"><img src="images/halfstar.png"><img src="images/blankstar.png">';

		 break;

	   case 8:

		 $str = '<img src="images/star.png"><img src="images/star.png"><img src="images/star.png"><img src="images/star.png"><img src="images/blankstar.png">';

		 break;

	   case 9:

		 $str = '<img src="images/star.png"><img src="images/star.png"><img src="images/star.png"><img src="images/star.png"><img src="images/halfstar.png">';

		 break;

	   case 10:

		 $str = '<img src="images/star.png"><img src="images/star.png"><img src="images/star.png"><img src="images/star.png"><img src="images/star.png">';

		 break;

	}

	

	return $str;

}



function getAverageRating($travelid){

    $rating=dbfetch(dbquery("SELECT AVG(Rating) FROM ratingsandcomments WHERE travelid=$travelid"));

    return intval($rating[0]);

}



function getCurlData($url, $post_fields = null, $headers = null) {

    $ch = curl_init();

    $timeout = 5;

    curl_setopt($ch, CURLOPT_URL, $url);

    

    if ($post_fields && !empty($post_fields)) {

        curl_setopt($ch, CURLOPT_POST, 1);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);

    }

    if ($headers && !empty($headers)) {

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    }

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);

    $data = curl_exec($ch);

    if (curl_errno($ch)) {

        echo 'CURL Error:' . curl_error($ch);

    }

    curl_close($ch);

    return $data;

} 



//Innovolist API for adding subs automatically

function innvo_autosub($apikey,$username,$data){

    //get new token

    $curl = curl_init();

    curl_setopt_array($curl, array(

        CURLOPT_RETURNTRANSFER => 1,

        CURLOPT_URL => "https://innovolist.com/api/auth/username=$username&apikey=$apikey"

    ));

    

    $res=json_decode(curl_exec($curl));

    curl_close($curl);

    

    if($res->status!="ok"){

        echo "Innovolist API Authentication Error!";

        die;

    }

    

    $api_token=$res->data->token;

    // echo "Token:$api_token"; 



    //Add new subscriber via API



    $url_param="";

    foreach ($data as $key => $value) {

        if($key!='name')

            $url_param.="&".$key."=".urlencode($value);

    }

            

    

    $curl = curl_init();

    $url1='https://innovolist.com/api/user/'.$api_token.'/addsubs/name='.urlencode($data['name']).$url_param;

    // echo $url1."<br>";

    curl_setopt_array($curl, array(

        CURLOPT_RETURNTRANSFER => 1,

        CURLOPT_URL => $url1

    ));

    

    $res=curl_exec($curl);

    // echo $res;

    curl_close($curl);

    //$url='http://innovolist.com/api/'.$api_token.'/addsub/val1='.$data[1].$url_param;

    //echo $url;

    return json_decode($res);

}

function getUserIP()

{

	if (isset($_SERVER['REMOTE_ADDR']) AND isset($_SERVER['HTTP_CLIENT_IP']))

		$ip = $_SERVER['HTTP_CLIENT_IP'];

	elseif (isset($_SERVER['REMOTE_ADDR']))

		$ip = $_SERVER['REMOTE_ADDR'];

	elseif(isset($_SERVER['HTTP_CLIENT_IP']))

		$ip = $_SERVER['HTTP_CLIENT_IP'];

	elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR']))

		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];



	return $ip;

}



function getCategoryName($id) {
    $rs = dbquery("SELECT name, parent FROM travelcategories WHERE ID = $id LIMIT 1");
    if ($rs && dbnumrows($rs) > 0) {
        return dbfetch($rs);
    }
    return null;
}

function checkCategoryIsParent($id)
{
    $category = dbfetch(dbquery("SELECT parent FROM travelcategories WHERE ID=$catid"));

    if($category[0]==0)
    return 0;
    else
    return 1;
}

function checkpath($filename)
{
    if (file_exists($filename)) {
        return $filename;
} else {
       return $siteurl.'/travelimages/no-img.png';
}

}

function getCatName($id)
{
    
    
   $query = dbfetch(dbquery("select * from  travelcategories where ID = $id"));
    
    return $query['name'];
}  



function checknumcat($id)
{
    include "config.php";
    //echo "select * from travelcategories where parent = $id";
    $qrt = dbquery("select * from travelcategories where parent = $id");
   
     $qrtnum = dbnumrows($qrt);
    
    if($qrtnum > 4)
      return 1;
    else
      return 0; 
}



function checksubcatabailable($id)
{
    include "config.php";
    $query = dbquery("select * from travelcategories where parent = $id");
    return dbnumrows($query);
}

function checklistingAbailable($id)
{
     include "config.php";
   
    $query = dbquery("select * from  travellisting where catid = $id ORDER BY RAND() LIMIT 2");
    
    $count = dbnumrows($query);
    return $count;
}

function getImgPushSetting()
{
    include "config.php";
   
    $query = dbfetch(dbquery("select * from  pushadmin"));
    
    return $query['pushLogo'];
}

function trav_url_encode($str)
{
    $name = str_replace(' ', '__', $str);
    $name = str_replace('&', '222222', $name);
    return $name;
}

function trav_url_decode($str)
{
    $name = str_replace( '__',' ', $str);
    $name = str_replace('222222','&', $name);
    return $name;
}

function APIData($fetch, $apiKey = null)
{
    include "config.php";
    $apiKey = $chatgptAPIKey;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/chat/completions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);

    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer '.$apiKey
    ]);

    // ✅ FIXED MODEL NAME
    $postData = [
        "model" => "gpt-4o-mini",
        "messages" => [
            ["role" => "user", "content" => $fetch]
        ],
        "temperature" => 0.7,
        "max_tokens" => 4500
    ];

    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

    $response = curl_exec($ch);
    $responseData = json_decode($response, true);

    // Debug log for API error (optional)
    if (isset($responseData['error']['message'])) {
        error_log("OpenAI API Error: " . $responseData['error']['message']);
    }

    if (curl_errno($ch) || !isset($responseData['choices'][0]['message']['content'])) {
        curl_close($ch);
        return "API Error or empty response";
    }

    $content = $responseData['choices'][0]['message']['content'];

    // Paragraph wrapping logic
    $lines = explode(PHP_EOL, $content);
    $htmlWrapped = "";
    foreach ($lines as $line) {
        $htmlWrapped .= "<p>".htmlspecialchars(trim($line))."</p>";
    }

    $finalContent = addslashes($htmlWrapped);

    curl_close($ch);
    return $finalContent;
}


function generateTravelMeta($location) {
    include "config.php";
   $apiKey = "sk-proj-fC4QZ2UATcvGuxQimV0XT3BlbkFJRFSGBmxN6eAw0T1sHl4i";

    // If location is numeric → it's travel ID, so fetch travelname
    if (is_numeric($location)) {

        $travelID = intval($location);

        $rs = dbquery("SELECT travelname,region,catid,listingarea,listingtype FROM travellisting WHERE ID=$travelID LIMIT 1");

        if (dbnumrows($rs) == 0) {
            error_log("Travel ID not found → " . $location);
            return false;
        }

        $row = dbfetch($rs);
        $location = $row['travelname']; // Convert integer ID into city name
        $region = $row['region'];
        $countryname = getCountryNameById($region);
        
        
        $catid = $row['catid'];
        $categoryName = getTravelCategoryName($catid);
        $listingarea = $row['listingarea'];
        $type = $row['listingtype'];
        
    }

    // Now $location is ALWAYS a readable city name
    $prompt = "Generate an SEO meta title (max 60 chars), meta description (max 155 chars), and meta keywords for a travel directory page about: 
    
    City: $location
Country: $countryname
Category: $categoryName
Listing Area: $listingarea
Listing Type: $type
    
    
    
    Focus on tourism, attractions, and why it's worth visiting. Return ONLY raw JSON. Do not wrap in markdown or backticks. Output JSON with keys: title, description, keywords.";

    // Debug the prompt
    echo "<textarea cols=50 rows=6>$prompt</textarea>";

    // Call API
    $ch = curl_init("https://api.openai.com/v1/chat/completions");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer " . $apiKey,
            "Content-Type: application/json"
        ],
        CURLOPT_POSTFIELDS => json_encode([
            "model" => "gpt-4o-mini",
            "messages" => [
                ["role" => "user", "content" => $prompt]
            ],
            "temperature" => 0.5,
            "max_tokens" => 400
        ])
    ]);

    print_r($res);

    $res = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($res, true);
    $metaRaw = $data["choices"][0]["message"]["content"] ?? null;

    if (!$metaRaw) {
        error_log("Meta generation failed → ".$res);
        return false;
    }

    // Clean JSON
    $metaRaw = preg_replace('/^```json\s*/', '', $metaRaw);
    $metaRaw = preg_replace('/\s*```$/', '', $metaRaw);
    $metaRaw = trim($metaRaw);

    $meta = json_decode($metaRaw, true);

    if (!$meta || !isset($meta["title"])) {
        error_log("Invalid JSON from AI → ".$metaRaw);
        return false;
    }

    return $meta;
}


function generateTravelImage($id, $apiKey = null, $quality = 'medium')
{
    include "config.php";
    $apiKey = "sk-proj-fC4QZ2UATcvGuxQimV0XT3BlbkFJRFSGBmxN6eAw0T1sHl4i";

    // Make folder if missing
    $folder = "../images/travel/";
    if (!is_dir($folder)) {
        mkdir($folder, 0777, true);
    }

    // Fetch travel row
    $q = dbquery("SELECT travelname, region, listingarea, travelicon FROM travellisting WHERE ID=$id");
    $r = dbfetch($q);

    if (!$r || empty($r['travelname'])) {
        error_log("Travel row missing for ID $id");
        return false;
    }

    $title     = $r['travelname'];
    $regionRaw = trim($r['region']);
    $countryId = intval($r['listingarea']);

    // --- Resolve Region ---
    if (function_exists('region')) {
        $region = region($regionRaw) ?: $regionRaw;
    } else {
        $region = $regionRaw;
    }


    // --- Resolve Country ---
    $country = null;
    if (function_exists('getCountryNameById')) {
        $country = getCountryNameById($countryId);
    }

    // Clean fallback rules:
    // 1. If region already contains a known country name, DO NOT add another
    // 2. If countryId is invalid AND region is NOT Indian → do NOT force India
    // 3. If truly Indian region → add India

    $knownCountries = ["United States", "United States of America", "UAE", "United Arab Emirates", "France", "Japan", "Canada", "Australia", "UK", "United Kingdom"];
    $indianRegions = ["delhi","mumbai","agra","kolkata","chennai","jaipur","goa","bengaluru","bangalore","hyderabad"];

    $regionLower = strtolower($region);

    // CASE 1: Region already contains a country name
    $regionIsCountry = false;
    foreach ($knownCountries as $c) {
        if (stripos($region, $c) !== false) {
            $regionIsCountry = true;
            break;
        }
    }

    if ($regionIsCountry) {
        // Example: region = "United States of America"
        $geoLocation = $region;
    }
    elseif ($country) {
        // Example: region = "New York", country = "United States"
        $geoLocation = "$region, $country";
    }
    elseif (in_array($regionLower, $indianRegions)) {
        // Example: region = "Delhi", no country stored
        $geoLocation = "$region, India";
    }
    else {
        // Final fallback: region only (avoid wrong ", India")
        $geoLocation = $region;
    }

    // --- Filename ---
    $title_clean  = strtolower(preg_replace('/[^a-zA-Z0-9]/', '_', $title));
    $region_clean = strtolower(preg_replace('/[^a-zA-Z0-9]/', '_', $region));
    $filename = $title_clean . "_" . $region_clean . ".jpg";
    $savePath = $folder . $filename;

    // --- FINAL IMAGE PROMPT (Correct International Version) ---
    $prompt = "
Ultra-realistic premium travel photograph of \"$title\", located in $geoLocation.
4K realism, cinematic lighting, authentic environmental detail, high-quality tourism image.
No text, no watermarks, no logos, no frames, no overlays. 
Clear composition, professional photography style suitable for a travel directory.";

    echo "<textarea cols=50 rows=6>$prompt</textarea>";

    // --- API call ---
    $body = [
        "model"   => "gpt-image-1",
        "prompt"  => $prompt,
        "n"       => 1,
        "size"    => "1024x1024",
        "quality" => $quality
    ];

    $ch = curl_init("https://api.openai.com/v1/images/generations");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $apiKey",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));

    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);

    if (!isset($data["data"][0]["b64_json"])) {
        error_log("OpenAI failed for travel image → " . $response);
        return false;
    }

    $imageData = base64_decode($data["data"][0]["b64_json"]);
    if (!$imageData) {
        error_log("Base64 decode failed for travel ID $id");
        return false;
    }

    if (!file_put_contents($savePath, $imageData)) {
        error_log("File save failed for ID $id");
        return false;
    }

    dbquery("UPDATE travellisting SET travelicon='$filename' WHERE ID=$id");

    return true;
}




function region($id) {
    include "config.php";
    $id = intval($id);

    $q = dbquery("SELECT country_name FROM countries WHERE id=$id");
    $r = dbfetch($q);

    if (!$r) {
        return "";
    }

    return $r['country_name'];
}

function getCountryNameById($id) {
    $id = intval($id); // sanitize

    if ($id <= 0) {
        return null;
    }

    $sql = "SELECT country_name FROM countries WHERE id = $id LIMIT 1";
    $rs  = dbquery($sql);

    if ($rs && dbnumrows($rs) > 0) {
        $row = dbfetch($rs);
        return $row['country_name'];
    }

    return null;
}




function generateTravelLongDesc($id, $apiKey = null) {
    include "config.php";

    $id = intval($id);
    $apiKey = "sk-proj-fC4QZ2UATcvGuxQimV0XT3BlbkFJRFSGBmxN6eAw0T1sHl4i";

   // Fetch travel row
    $q = dbquery("SELECT travelname, region, listingarea, travelicon,catid FROM travellisting WHERE ID=$id");
    $r = dbfetch($q);

    if (!$r || empty($r['travelname'])) {
        error_log("Travel row missing for ID $id");
        return false;
    }
    
    

    $title     = $r['travelname'];
    $regionRaw = trim($r['region']);
    $countryId = intval($r['listingarea']);
    $catid = $r['catid'];
    
    $city3 = dbfetch(dbquery("select name from travelcategories where ID=$catid"));
    
    $catname = $city3[0];
    
    
    // --- Resolve Region ---
    if (function_exists('region')) {
        $region = region($regionRaw) ?: $regionRaw;
    } else {
        $region = $regionRaw;
    }


    // --- Resolve Country ---
    $country = null;
    if (function_exists('getCountryNameById')) {
        $country = getCountryNameById($countryId);
    }

    // Clean fallback rules:
    // 1. If region already contains a known country name, DO NOT add another
    // 2. If countryId is invalid AND region is NOT Indian → do NOT force India
    // 3. If truly Indian region → add India

    $knownCountries = ["United States", "United States of America", "UAE", "United Arab Emirates", "France", "Japan", "Canada", "Australia", "UK", "United Kingdom"];
    $indianRegions = ["delhi","mumbai","agra","kolkata","chennai","jaipur","goa","bengaluru","bangalore","hyderabad"];

    $regionLower = strtolower($region);

    // CASE 1: Region already contains a country name
    $regionIsCountry = false;
    foreach ($knownCountries as $c) {
        if (stripos($region, $c) !== false) {
            $regionIsCountry = true;
            break;
        }
    }

    if ($regionIsCountry) {
        // Example: region = "United States of America"
        $geoLocation = $region;
    }
    elseif ($country) {
        // Example: region = "New York", country = "United States"
        $geoLocation = "$region, $country";
    }
    elseif (in_array($regionLower, $indianRegions)) {
        // Example: region = "Delhi", no country stored
        $geoLocation = "$region, India";
    }
    else {
        // Final fallback: region only (avoid wrong ", India")
        $geoLocation = $region;
    }
    
    
    
    

    // FINAL PROMPT (same as yours, only location updated)
    $prompt = "
Generate a detailed travel directory description for the

Place: $title,$catname
Geo Location String: $geoLocation


OUTPUT RULES:

Output ONLY clean HTML content — no <html>, no <head>, no <body>, no meta tags, no scripts, no URLs, no external links.

Content must be formatted using <h1>, <h2>, <p>, <ul>, <li>, <strong>, and <em> where appropriate.

Must be AEO-optimized, GEO-optimized, and SEO-friendly.

Write 600–900 words (or more if the place requires deep coverage).

Include history, significance, architecture/nature details, visitor highlights, cultural importance, best time to visit, and travel tips.

Maintain high uniqueness, no repetition, no filler, no generic sentences.

DO NOT include JSON, scripts, inline CSS, schema, breadcrumbs, or boilerplate text.

ONLY return the clean HTML description, fully formatted and ready to publish on a travel directory website.

";

echo "<textarea cols=50 rows=6>$prompt</textarea>";

    // ---- Curl call
    $ch = curl_init("https://api.openai.com/v1/chat/completions");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 40);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $apiKey",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        "model" => "gpt-4.1-mini",
        "messages" => [
            ["role" => "user", "content" => $prompt]
        ],
        "temperature" => 0.5,
        "max_tokens" => 3500
    ]));

    $res = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($res, true);
    $html = $data['choices'][0]['message']['content'] ?? null;

    if (!$html) {
        error_log("Long description generation failed for ID $id → ".$res);
        return false;
    }

    $htmlTrim = trim($html);
    $htmlEsc  = addslashes($htmlTrim);

    $result = dbquery("UPDATE travellisting SET description='$htmlEsc' WHERE ID=$id");

    if (!$result) {
        $err = dberror("while updating Travel description for ID $id");
        echo "Database Error ❌: " . $err;
    } else {
        echo "Update Successful ✅";
    }

    return $htmlTrim;
}



function short_text($text, $limit = 120) {
    $clean = strip_tags($text);
    if (strlen($clean) > $limit) {
        return substr($clean, 0, $limit) . '...';
    }
    return $clean;
}

function getTravelCategoryName($id) {
    include "config.php";

    // Sanitize ID as integer
    $id = intval($id);

   

    // Run query
    $rs = dbquery("SELECT name FROM travelcategories WHERE ID = $id LIMIT 1");

    // If found, return name
    if ($rs && dbnumrows($rs) > 0) {
        $row = dbfetch($rs);
        return $row['name'];
    }

    // If not found, return empty or custom text
    return "";
}

function removeIndiaWord($text) {
    if (!$text) return $text;

    // remove standalone "India" safely (case-insensitive)
    $text = preg_replace('/\bindia\b/i', '', $text);

    // clean double commas and spaces
    $text = preg_replace('/,\s*,/', ',', $text);
    $text = preg_replace('/\s{2,}/', ' ', $text);
    $text = trim($text, " ,");

    return trim($text);
}


function generateCategoryShortDesc($catid, $apiKey = null) {
    include "config.php";

    $catid = intval($catid);
    $apiKey = $apiKey ?: $chatgptAPIKey;

    // Fetch category
    $q = dbquery("SELECT name, parent, MetaTitle FROM travelcategories WHERE ID=$catid");
    $r = dbfetch($q);

    if (!$r || empty($r['name'])) {
        error_log("Category row missing for ID $catid");
        return false;
    }

    $catName   = trim($r['name']);
    $metaTitle = trim($r['MetaTitle']);

    // Fetch parent category name (if exists)
    $parentName = "";
    if (!empty($r['parent'])) {
        $p = dbfetch(dbquery("SELECT name FROM travelcategories WHERE ID=".(int)$r['parent']));
        if ($p) {
            $parentName = $p[0];
        }
    }

    // Build context string
    $context = $catName;
    if ($parentName) {
        $context .= " (Category under $parentName)";
    }
    
    
    $cleanContext   = removeIndiaWord($context);
$cleanMetaTitle = removeIndiaWord($metaTitle);

    // ---- AI PROMPT (SHORT DESCRIPTION) ----
    echo $prompt = "
Generate a complete, SEO-friendly, AEO-optimized, GEO-targeted travel directory description.

Attraction Name: $catName
Geo Location: $cleanContext
Meta Title (if helpful): $cleanMetaTitle

CONTENT STRUCTURE (must follow this order):

1. Overview (Short Introduction)
2. Key Highlights & Features
3. What $catName Is Known For
4. Timings
5. Tips for Visitors
6. Required Time
7. Restricted Items
8. More About $catName
9. Architecture of $catName (only if applicable)
10. Best Time to Visit
11. How to Reach
12. Nearby Tourist Spots
13. FAQs (4–6 frequently asked questions with clear answers)

OUTPUT RULES (VERY IMPORTANT):

- Output ONLY clean HTML
- Use only: <h2>, <p>, <ul>, <li>, <strong>, <em>
- Do NOT include <html>, <head>, <body>, schema, JSON, scripts, CSS, or comments
- Do NOT include any hotel or restaurant details unless part of the attraction itself
- Do NOT include external links or URLs
- Maintain a natural, informative, travel-directory tone
- SEO + AEO optimized with subtle GEO keywords
- No repetition, no filler, no generic sentences
- Content must be original and high quality
- Suitable for publishing directly on a travel directory website

Return ONLY the clean HTML content and nothing else.
";


    // ---- CURL CALL ----
    $ch = curl_init("https://api.openai.com/v1/chat/completions");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_TIMEOUT        => 30,
        CURLOPT_HTTPHEADER     => [
            "Authorization: Bearer $apiKey",
            "Content-Type: application/json"
        ],
        CURLOPT_POSTFIELDS     => json_encode([
            "model" => "gpt-4.1-mini",
            "messages" => [
                ["role" => "user", "content" => $prompt]
            ],
            "temperature" => 0.4,
            "max_tokens"  => 2200
        ])
    ]);

    $res = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($res, true);
    $html = $data['choices'][0]['message']['content'] ?? null;

    if (!$html) {
        error_log("Category short description generation failed → ".$res);
        return false;
    }

    // Clean & escape
    $htmlTrim = trim($html);
    $htmlEsc  = addslashes($htmlTrim);

    // Update DB
    $result = dbquery("UPDATE travelcategories SET shortdes='$htmlEsc' WHERE ID=$catid");

    if (!$result) {
        echo "DB Error ❌ while updating category shortdes";
        return false;
    }

    return $htmlTrim;
}

function slugify($text) {
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, '-');
    $text = preg_replace('~-+~', '-', $text);
    $text = strtolower($text);
    if (empty($text)) return 'n-a';
    return $text;
}

function dbRowInsert($table, $form_data)
{
    if (empty($table) || empty($form_data) || !is_array($form_data)) {
        return false;
    }

    $fields = [];
    $values = [];

    foreach ($form_data as $field => $value) {
        $fields[] = "`" . addslashes($field) . "`";
        $values[] = "'" . addslashes($value) . "'";
    }

    $fieldList = implode(",", $fields);
    $valueList = implode(",", $values);

    $sql = "INSERT INTO `$table` ($fieldList) VALUES ($valueList)";

    if (dbquery($sql)) {
        return lastinsertid(); // MUST EXIST
    }

    return false;
}


function getListingFullUrl($listingId, $siteurl) {

    $listingId = (int)$listingId;

    /* ================= LISTING ================= */
    $listing = dbfetch(dbquery("
        SELECT slug, catid FROM travellisting
        WHERE ID = $listingId 
        LIMIT 1
    "));
    if (!$listing || empty($listing['slug'])) {
        return cleanUrl($siteurl);
    }

    /* ================= CITY ================= */
    $city = dbfetch(dbquery("
        SELECT slug, parent
        FROM travelcategories
        WHERE ID = {$listing['catid']}
        LIMIT 1
    "));
    if (!$city) return cleanUrl($siteurl);

    /* ================= STATE ================= */
    $state = dbfetch(dbquery("
        SELECT slug, parent
        FROM travelcategories
        WHERE ID = {$city['parent']}
        LIMIT 1
    "));
    if (!$state) return cleanUrl($siteurl);

    /* ================= COUNTRY ================= */
    $country = dbfetch(dbquery("
        SELECT slug
        FROM travelcategories
        WHERE ID = {$state['parent']}
        LIMIT 1
    "));
    if (!$country) return cleanUrl($siteurl);

    /* ================= FINAL URL ================= */
    return cleanUrl(
        $siteurl,
        $country['slug'].'/'.$state['slug'].'/'.$city['slug'].'/'.$listing['slug']
    ) . '/';
}


function cleanUrl($base, $path = '') {

    $base = rtrim(trim($base), '/');
    $path = ltrim(trim($path), '/');

    return $path === ''
        ? $base . '/'
        : $base . '/' . $path;
}





?>