<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include "header.php";
include "config.php";
include "func.php";

$msg  = "";
$type = "";

/* 🚫 Direct access protection */
if (!isset($_POST['newsletter_submit'])) {
    header("Location: index.php");
    exit;
}

/* ================= EMAIL VALIDATION ================= */
$email = strtolower(trim($_POST['email_newsletter_2'] ?? ''));

if ($email === "") {
    $msg  = "Please enter email";
    $type = "error";
}
elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $msg  = "Invalid email address";
    $type = "error";
}

/* ================= CAPTCHA VALIDATION ================= */
else {

    $recaptcha = $_POST['g-recaptcha-response'] ?? '';
    $capError  = "";

    if (empty($recaptcha)) {

        $capError = "Please re-enter your reCAPTCHA.";

    } else {

        $google_url = "https://www.google.com/recaptcha/api/siteverify";
        $secret     = $googlesecret;
        $ip         = getUserIP();

        $url = $google_url
             . "?secret="   . urlencode($secret)
             . "&response=" . urlencode($recaptcha)
             . "&remoteip=" . urlencode($ip);

        $res = getCurlData($url);
        
       
        
        $res = json_decode($res, true);

        if (empty($res['success'])) {
            $capError = "Please re-enter your reCAPTCHA.";
        }
    }

    /* ================= CAPTCHA RESULT ================= */
    if ($capError !== "") {

        $msg  = $capError;
        $type = "error";

    } else {


    echo $msg;    

        /* ================= DUPLICATE CHECK ================= */
         $emailSafe = addslashes($email);

        $chk = dbquery("SELECT id FROM newsletter WHERE email='$emailSafe' LIMIT 1");

        if (dbnumrows($chk) > 0) {

            $msg  = "You are already subscribed.";
            $type = "error";

        } else {
            
            /* ================= INSERT ================= */
            dbquery("
                INSERT INTO newsletter (email, created_at, status)
                VALUES ('$emailSafe', NOW(), 1)
            ");

            $msg  = "🎉 Subscribed successfully!";
            $type = "success";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Newsletter Subscription</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
.main {
    margin: 0;
    font-family: Arial, sans-serif;
    min-height: 50vh;
    display: flex;
    align-items: center;
    justify-content: center;
}
.subscribe-box {
    background: #fff;
    padding: 3rem;
    border-radius: 1.5rem;
    max-width: 420px;
    width: 90%;
    text-align: center;
    box-shadow: 0 20px 40px rgba(0,0,0,0.2);
    animation: fadeIn .6s ease;
}
.subscribe-box h2 {
    font-size: 2.2rem;
    margin-bottom: 1rem;
}
.subscribe-box p {
    font-size: 1.6rem;
    margin-bottom: 2rem;
}
.success { color: #16a34a; }
.error   { color: #dc2626; }

.btn-home {
    display: inline-block;
    padding: 1.2rem 3rem;
    background: #2563eb;
    color: #fff;
    text-decoration: none;
    font-size: 1.5rem;
    border-radius: 3rem;
    transition: 0.3s;
}
.btn-home:hover {
    background: #1e40af;
    transform: translateY(-2px);
}
@keyframes fadeIn {
    from { opacity:0; transform:translateY(20px); }
    to   { opacity:1; transform:translateY(0); }
}
</style>
</head>

<div class="main">
    <div class="subscribe-box">

        <h2 class="<?php echo $type; ?>">
            <?php echo htmlspecialchars($msg); ?>
        </h2>

        <?php if ($type === "success") { ?>
            <p>Thank you for joining our newsletter.</p>
        <?php } else { ?>
            <p>Please try again.</p>
        <?php } ?>

        <a href="index.php" class="btn-home">← Back to Home</a>

    </div>
</div>

<?php include 'footer.php'; ?>
