<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

//header('Content-Type: application/json');



include_once 'config.php';
include_once 'func.php';

/* ------------------------
   DEBUG HELPER
------------------------- */
function json_exit($status, $msg, $extra = [])
{
    echo json_encode(array_merge([
        "status" => $status,
        "msg"    => $msg
    ], $extra));
    exit;
}

/* ------------------------
   VALIDATE REQUEST
------------------------- */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_exit(0, "Invalid request method");
}

if (empty($_POST['email'])) {
    json_exit(0, "Email is required");
}

$email = trim($_POST['email']);

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    json_exit(0, "Invalid email format");
}

/* ------------------------
   CHECK DUPLICATE
------------------------- */
$checkSql = "SELECT ID FROM subscribers WHERE Email = '" . $email . "' LIMIT 1";
$checkRs  = dbquery($checkSql);

if (!$checkRs) {
    json_exit(0, "Database error (check)", ["mysql" => mysqli_error($dbconnect)]);
}

if (dbnumrows($checkRs) > 0) {
    json_exit(1, "You are already subscribed");
}

/* ------------------------
   INSERT SUBSCRIBER
------------------------- */
$ip = $_SERVER['REMOTE_ADDR'];
$now = date("Y-m-d H:i:s");

$form_data = [
    'Email'  => $email,
    'IP'     => $ip,
    'Date'   => $now,
    'status' => 1,
    'PDate'  => $now
];

$insertId = dbRowInsert('subscribers', $form_data);

if (!$insertId) {
    json_exit(0, "Failed to subscribe", ["mysql" => mysqli_error($dbconnect)]);
}

/* ------------------------
   SUCCESS
------------------------- */
json_exit(2, "Thanks for subscribing!");
