<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include_once 'config.php';
include_once 'func.php';

/* ---------------------------
   SLUG GENERATOR
---------------------------- */
function make_slug($string)
{
    $string = strtolower(trim($string));
    $string = html_entity_decode($string, ENT_QUOTES, 'UTF-8');
    $string = preg_replace('~[^a-z0-9]+~', '-', $string);
    return trim($string, '-');
}
/* =====================================================
   PLACE URLS (WORKING ALREADY)
===================================================== */
$sql = "
SELECT 
    p.ID,
    p.travelname,
    p.slug AS place_slug,
    c.slug AS city_slug,
    s.slug AS state_slug,
    co.slug AS country_slug
FROM travellisting p
LEFT JOIN travelcategories c  ON c.ID = p.catid
LEFT JOIN travelcategories s  ON s.ID = c.parent
LEFT JOIN travelcategories co ON co.ID = s.parent
WHERE p.status = 1
ORDER BY p.ID ASC
";

$rs = dbquery($sql);

while ($row = dbfetch($rs)) {

    if (!$row['place_slug'] || !$row['city_slug']) continue;

    $oldUrl = rtrim($siteurl,'/') .
              "/place/" .
              urlencode($row['travelname']) .
              "/" .
              $row['ID'];

    $newUrl = rtrim($siteurl,'/') . "/" .
              $row['country_slug'] . "/" .
              $row['state_slug'] . "/" .
              $row['city_slug'] . "/" .
              $row['place_slug'] . "/";

    /*echo "OLD:\n\n";
    echo "NEW:\n$newUrl\n";
    echo str_repeat("-", 70) . "\n";*/
$oldUrl=str_ireplace("https://www.tripgoeson.com","",$oldUrl);
echo "Redirect 301 $oldUrl $newUrl<br>";
}

/* =====================================================
   CITY URLS (FIXED FOR BOTH /1 AND /ID)
===================================================== */
$sql = "
SELECT 
    c.ID,
    c.name,
    c.slug,
    s.slug  AS state_slug,
    co.slug AS country_slug
FROM travelcategories c
LEFT JOIN travelcategories s  ON s.ID = c.parent
LEFT JOIN travelcategories co ON co.ID = s.parent
WHERE c.status = 1
";

$rs = dbquery($sql);

while ($row = dbfetch($rs)) {

    $citySlug = $row['slug'] ?: make_slug($row['name']);

    $oldUrl1 = rtrim($siteurl,'/') . "/city/" . urlencode($row['name']) . "/1";
    $oldUrl2 = rtrim($siteurl,'/') . "/city/" . urlencode($row['name']) . "/" . $row['ID'];

    if ($row['country_slug'] && $row['state_slug']) {
        // FULL hierarchy exists
        $newUrl = rtrim($siteurl,'/') . "/" .
                  $row['country_slug'] . "/" .
                  $row['state_slug'] . "/" .
                  $citySlug . "/";
    } elseif ($row['country_slug']) {
        // ONLY country exists
        $newUrl = rtrim($siteurl,'/') . "/" .
                  $row['country_slug'] . "/" .
                  $citySlug . "/";
    } else {
        // LAST fallback
        $newUrl = rtrim($siteurl,'/') . "/" . $citySlug . "/";
    }

/*    echo "OLD:\n$oldUrl1\n";
    echo "OLD:\n$oldUrl2\n";
    echo "NEW:\n$newUrl\n";
    echo str_repeat("-", 70) . "\n";*/
	$oldUrl=str_ireplace("https://www.tripgoeson.com","",$oldUrl2);
	echo "Redirect 301 $oldUrl $newUrl<br>";
}
?>